close all 

H = cell(3,1);

for t = 1:3
    giant = CoauAdjSankey{t,2};  %%% get the giant component 
    H{t,1} = CoauAdjSankey{t,1}(giant, giant);   %%%% get the adjacency matrix
    size(H{t,1})
    SgnQ(H{t,1})
end

%%%%%% use K == 2 to extract clique, compute SgnQ 
%%%%%% K = 3, 4 do not perform well (all pvs are zero) 
K_all = [2 2 2];
size_vs_pv = cell(3,1);
com_idx = cell(3,1);
net = cell(3,1);

for t = 1:length(K_all)
    K = K_all(t);
    size_vs_pv{t} = zeros(2,K);
    G = CoauAdjSankey{t,2};  %%% get the giant component 
    A = CoauAdjSankey{t,1}(G, G);   %%%% get the adjacency matrix on gc
    net{t} = A;
    n = size(A,1);
    labels = SCORE(A + eye(n), K); %%% apply SCORE on gc

    com_idx{t} = cell(K,1);
    for ell = 1:K
        com_idx{t}{ell} = find(labels == ell);
    end
    
    %%%%%% plot graphs + communities, compute SgnQ
    figure 
    A_graph = graph(A);
    plot(A_graph,'NodeLabel',labels)

    for ell = 1:K
        figure 
        size_vs_pv{t}(1, ell) = SgnQ( A(com_idx{t}{ell}, com_idx{t}{ell}) );
        size_vs_pv{t}(2, ell) = length(com_idx{t}{ell}); 
        plot( graph(A(com_idx{t}{ell}, com_idx{t}{ell})),'NodeLabel',labels(com_idx{t}{ell}))
    end 

    size_vs_pv{t}
end 